# KAX :: Kerbal Aircraft Expansion



Kerbal Aircraft Expansion : **forever** _THE_ pack of selected vanilla-inspired parts for your aircrafting needs!

KAX/L is KAX under Lisias' Management.


## In a Hurry

* [Source](https://github.com/net-lisias-ksp/KAX)
	+ [Issue Tracker](https://github.com/net-lisias-ksp/KAX/issues)
	+ [History](https://github.com/net-lisias-ksp/KAX/tree/History)
* Documentation
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/180268-*)
	+ [Homepage](http://ksp.lisias.net/add-ons/KAX) on L Aerospace KSP Division
	+ [Project's README](https://github.com/net-lisias-ksp/KAX/blob/master/README.md)
	+ [Install Instructions](https://github.com/net-lisias-ksp/KAX/blob/master/INSTALL.md)
	+ [Change Log](./CHANGE_LOG.md)
	+ [Known Issues](./KNOWN_ISSUES.md)
	+ [TODO](https://github.com/net-lisias-ksp/KAX/blob/master/TODO.md) list
* Official Distribution Sites:
	+ [SpaceDock](https://spacedock.info/mod/2150/KAX)
	+ [Source and Binaries](https://github.com/net-lisias-ksp/KAX) on GitHub.
	+ [Latest Release](https://github.com/net-lisias-ksp/KAX/releases)
		- [Binaries](https://github.com/net-lisias-ksp/KAX/tree/Archive)


## Description

A Mod for Kerbal Space Program

Originally created by Keptin, then maintained by SpannerMonkey and the SM Industries team, and now under Lisias' Management, KAX is a pack of select vanilla-inspired parts for your aircrafting needs!

Included Parts:

- Turboprop
- Radial Engine
- Electric Propeller
- Helicopter Main Rotor
- Helicopter Tail Rotor
- Heavy Landing Gear
- Jump Jet Engine
- 2M Aircraft Cockpit
- 2M Fuselage (jet fuel)
- 2M Structural Fuselage (empty)
- 2M Tail Boom 

Extract the KAX folder, into your KSP Gamedata folder.  

Be sure to properly extract the Firespitter/Resources folder or you will have FScoolant errors on loading the electric prop.  

This mod Requires Firespitter and Module Manager to enable all the features. Please use the latest versions of their .dll plugins.


### Configuration

Now you can choose how to handle your KAX parts and future new enhancements by editing the file `<KSP_ROOT>PluginData/KAX/user.cfg` that will be automatically created by KAX on the first run.

#### VAB/SPH Parts Menu

You can choose between three options:

* New Advanced Menu
	+ `CategoryFilter = NEW`
	+ ![](./PR_Material/Config/CategoryFilterNew.png)
* Old, classic Menu
	+ `CategoryFilter = OLD`
	+ ![](./PR_Material/Config/CategoryFilterOld.png)
* No specialized menu at all
	+ `CategoryFilter = NONE`
	+ ![](./PR_Material/Config/CategoryFilterNone.png)

The new Advanced Menu has shows only KAX parts with submenus specialised by category:

![](./PR_Material/Config/CategoryFilterNewScreen.png)

The old, classic menu is an old friend: all KAX parts on the same category on the simplified menu:

![](./PR_Material/Config/CategoryFilterOldScreen.png)

People using [Community Category Kit](https://forum.kerbalspaceprogram.com/index.php?/topic/149840-discussion-community-category-kit/) would want to disable the menu at all, as CCK already handles all of that.


### Project Directives

This Management (Lisias) had agreed to oblige himself to the following directives for this project:

* **KAX will remain KAX**
	+ it will not be rolled into another mod
	+ it can be expanded
		- expansions must be in keeping with the tone of the mod
		- it must be vaguely (as much as possible) stockalike. 

This project aims to preserve the stock a like compatibility and versatility  of these parts, and any subsequent parts will be designed with that in mind.  The goal is that any new part will blend seamlessly with the current parts and add to rather than detract from the mods functionality.

## Installation

Detailed installation instructions are now on its own file (see the [In a Hurry](#in-a-hurry) section) and on the distribution file.

Powered by Firespitter, special thanks to Snjo for his plugin and continued support!

### License

KAX is licensed under the following terms:

* KAX models, textures, and sounds are created by Keptin, who retains all copyrights. See [here](./LICENSE.KAX).
	+ You may:
		- Modify KAX in anyway for your personal use
		- Use KAX models, textures, and assets to create derivative works
		- Distribute sufficiently modified versions of KAX parts or newly created derivative parts
		- Distribute video, screenshots or other media portraying unmodified or modified versions of KAX
		- _**All other rights are reserved**_
	+ Specifically, you may not:
		- Distribute unmodified versions of KAX, in part or whole, without permission
		- Use KAX for any commercial purpose
* Plugin Source Code (C# project) are **double licensed** at user discretion when applicable (use the license that best suits your needs - when allowed by Law):
	+ [SKL 1.0](https://ksp.lisias.net/SKL-1_0.txt). See [here](./LICENSE.KSPe.SKL-1_0)
		+ You are free to:
			- Use : unpack and use the material in any computer or device
			- Redistribute: redistribute the original package in any medium
		+ Under the following terms:
			- You agree to use the material only on (or to) KSP
			- You don't alter the package in any form or way (but you can embedded it)
			- You don't change the material in any way, and retain any copyright notices
			- You must explicitly state the author's Copyright, as well an Official Site for downloading the original and new versions
	+ [GPL 2.0](https://www.gnu.org/licenses/gpl-2.0.txt). See [here](./LICENSE.KSPe.GPL-2_0)
			+ You are free to:
				- Use : unpack and use the material in any computer or device
				- Redistribute : redistribute the original package in any medium
				- Adapt : Reuse, modify or incorporate source code into your works (and redistribute it!)
			+ Under the following terms:
				- You retain any copyright notices
				- You recognize and respect any trademarks
				- You don't impersonate the authors, neither redistribute a derivative that could be misrepresented as theirs.
				- You credit the author and republish the copyright notices on your works where the code is used.
				- You relicense (and fully comply) your works using GPL 2.0 (or later)
				- You don't mix your work with GPL incompatible works.
	* If by some reason the GPL would be invalid for you, rest assured that you still retain the right to Use the Work under SKL 1.0.

See [LICENSE](./LICENSE) for the formal legalese. Please note the copyrights and trademarks in [NOTICE](./NOTICE).


### Acknowledgements

Powered by [Firespitter](https://github.com/snjo/Firespitter/releases), special thanks to [Snjo](https://forum.kerbalspaceprogram.com/index.php?/profile/57198-snjo/) for his plugin and to [RoverDude](https://forum.kerbalspaceprogram.com/index.php?/profile/105198-roverdude/) for continued support!

Stockalike textures by [Doctor Davinci](https://forum.kerbalspaceprogram.com/index.php?/profile/150019-doctordavinci/)


## References

* [SpannerMonkey(smce)](https://forum.kerbalspaceprogram.com/index.php?/profile/50907-spannermonkeysmce/) -- Previous Maintainer
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/166467-kerbal-aircraft-expansion-_continued/)
	+ [GitHub](https://github.com/SpannerMonkey/KAX)
* [Keptin](https://forum.kerbalspaceprogram.com/index.php?/profile/8884-keptin/) -- Original Author
	+ [Forum](https://forum.kerbalspaceprogram.com/index.php?/topic/155448-122-kerbal-aircraft-expansion-kax-v264/&)
	+ [Curse Forge](https://kerbal.curseforge.com/projects/kerbal-aircraft-expansion-kax/files/2358481)
